/*************************************************************************

This function is an exemple of how to use liblo library to send OSC 
package from Matlab. The function need to be compiled with mex before to 
be use and the library installed before the compilation.


use this to compile in Matlab
!mex -Wl,-rpath,/usr/local/lib/ sendmat.c  /usr/local/lib/liblo.so

Then you can call the function with:

sendmat(remotehost,port,'/alpha','f',1,Y1);

Input:
 - remotehost: a string with the name of the remote host
 - port: a string with the port number to connect
 - header: header of the OSC message, e.g. '/alpha'
 - type: type tag of the OSC message, e.g. 'f'
 - size: int number with the size of the data to send
 - data: data to be send 

Author: Quentin Noirhomme

As this is a simple exemple you can only send one data at the time.

Copyright (c) 2005 Facult Polytechnique de Mons (eNTERFACE'05 workshop) -
Burak Arslan, Andrew Brouse, Julien Castet, Jean-Julien Filatriau,
Rmy Lehembre, Quentin Noirhomme, and Cdric Simon

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Users shall give appropriate references to the eNTERFACE'05 Website
(www.enterface.net) in scholarly literature for which this software is used
or mentioned.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
***************************************************************************/

#include "math.h"
#include "mex.h" 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "/usr/local/include/lo/lo.h"


void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    /*lo_address t = lo_address_new(NULL,"7770");
     lo_address t = lo_address_new("10.104.11.57","6000");
     lo_send(t, "/alpha", "iiiii", k,23,43,345,56);*/
  /*read input*/
  if (nrhs < 6) {
    printf("Not enough argument!!");
    return;
  } else {
    char *address;
    char *port;
    char *path;
    char *typetag;
    int narg;
    float data;
    int yLength;
    /*read address*/
    yLength = mxGetN(prhs[0])+1;
    address = mxCalloc(yLength, sizeof(char)); 
    mxGetString(prhs[0],address,yLength);
    printf(address);
    printf("\n");
    /*read port*/
    yLength = mxGetN(prhs[1])+1;
    port = mxCalloc(yLength, sizeof(char)); 
    mxGetString(prhs[1],port,yLength);
    printf(port);
    printf("\n");
    /*read path*/
    yLength = mxGetN(prhs[2])+1;
    path = mxCalloc(yLength, sizeof(char)); 
    mxGetString(prhs[2],path,yLength);
    printf(path);
    printf("\n");
    /*read typetag*/
    yLength = mxGetN(prhs[3])+1;
    typetag = mxCalloc(yLength, sizeof(char)); 
    mxGetString(prhs[3],typetag,yLength);
    printf(typetag);
    printf("\n");
    /*read number of argument*/
    narg = (int)(mxGetScalar(prhs[4]));
    printf("%i\n",narg);
    /*read data*/
    data =(float) (mxGetScalar(prhs[5]));
    printf("%f\n",data);
    lo_address t = lo_address_new(address,port);
     lo_send(t, path, typetag, data);
  }
  return;
}
        
